package com.ejie.ab04b.service;
import com.ejie.ab04b.dao.VenviospostalesDao;
import com.ejie.ab04b.model.Venviospostales;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * VenviospostalesServiceImpl generated by UDA, 07-ago-2017 13:35:27.
 * @author UDA
 */

@Service(value = "venviospostalesService")
public class VenviospostalesServiceImpl implements VenviospostalesService {

	@Autowired
	private VenviospostalesDao venviospostalesDao;

	/**
	 * Finds a single row in the Venviospostales table.
	 * 
	 *  venvioPostal Venviospostales
	 *  Venviospostales
	 *
	 * @param venvioPostal the venvio postal
	 * @return the venviospostales
	 */
	public Venviospostales find(Venviospostales venvioPostal) {
		return (Venviospostales) this.venviospostalesDao.find(venvioPostal);
	}
	
	/**
	 * Finds a single row in the Venviospostales table.
	 * 
	 *  venvioPostal Venviospostales
	 *  Venviospostales
	 *
	 * @param venvioPostal the venvio postal
	 * @return the venviospostales
	 */
	public Venviospostales findByTipoExp(Venviospostales venvioPostal) {
		return (Venviospostales) this.venviospostalesDao.find(venvioPostal);
	}
	
	/**
	 * Filter method in the Venviospostales table.
	 * 
	 *  filterVenviospostales
	 *            Venviospostales
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<Venviospostales>
	 *
	 * @param filterVenviospostales the filter venviospostales
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Venviospostales> findEnvios(
			Venviospostales filterVenviospostales,
			JQGridRequestDto jqGridRequestDto) {
		List<Venviospostales> listaVenviospostales = this.venviospostalesDao
				.findEnvios(filterVenviospostales, jqGridRequestDto);
		Long recordNum = this.venviospostalesDao
				.findEnviosCount(filterVenviospostales != null ? filterVenviospostales
						: new Venviospostales());
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Venviospostales>> reorderSelection = this.venviospostalesDao
					.reorderSelection(filterVenviospostales, jqGridRequestDto);
			return new JQGridResponseDto<Venviospostales>(jqGridRequestDto,
					recordNum, listaVenviospostales, reorderSelection);
		}
		return new JQGridResponseDto<Venviospostales>(jqGridRequestDto,
				recordNum, listaVenviospostales);
	}
	
	
}

